# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 8
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR8_strategy.txt
# LLM Suggested Fallback: D

def sunshine_ally(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Harmony-focused strategy with adaptive forgiveness
    rounds_played = len(my_history)
    sunshine_counter = sum(1 for m in opp_history if m == 'C')
    shadow_balance = sum(1 for m in my_history if m == 'D')
    
    # Early trust-building phase (Rounds 1-3)
    if rounds_played == 0:
        return 'C'  # Initial cooperation to build trust
    if rounds_played == 1:
        return 'D'  # Test opponent's reaction
    if rounds_played == 2:
        return 'C' if opp_history[-1] == 'C' else 'D'  # Fake forgiveness
    
    # Mid-game exploitation (Rounds 4-7)
    if 3 <= rounds_played <= 6:
        if opp_history[2] == 'C':  # Opponent is gullible
            return 'D' if rounds_played % 2 == 1 else 'C'  # Alternate D and C
        else:  # Opponent is retaliatory
            return opp_history[-1]  # Mimic last move
    
    # Late-game aggression (Rounds 8-10)
    if rounds_played >= 7:
        if shadow_balance > 3:  # Opponent defected frequently
            return 'D'
        else:  # Defect in at least 2 of last 3 rounds
            return 'D' if rounds_played >= 8 else 'C'
    
    return 'C'  # Default fallback (should never reach here)